package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationInstancesResponse(
    applicationInstances: Optional[
      Iterable[zio.aws.panorama.model.ApplicationInstance]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse = {
    import ListApplicationInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse
      .builder()
      .optionallyWith(
        applicationInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationInstances)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly =
    zio.aws.panorama.model.ListApplicationInstancesResponse
      .wrap(buildAwsValue())
}
object ListApplicationInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListApplicationInstancesResponse =
      zio.aws.panorama.model.ListApplicationInstancesResponse(
        applicationInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationInstances
        : Optional[List[zio.aws.panorama.model.ApplicationInstance.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApplicationInstances: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.ApplicationInstance.ReadOnly
    ]] =
      AwsError.unwrapOptionField("applicationInstances", applicationInstances)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse
  ) extends zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly {
    override val applicationInstances
        : Optional[List[zio.aws.panorama.model.ApplicationInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.ApplicationInstance.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse
  ): zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
