package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{NextToken, NameFilter, MaxSize25}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    deviceAggregatedStatusFilter: Optional[
      zio.aws.panorama.model.DeviceAggregatedStatus
    ] = Optional.Absent,
    maxResults: Optional[MaxSize25] = Optional.Absent,
    nameFilter: Optional[NameFilter] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.panorama.model.ListDevicesSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.panorama.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListDevicesRequest
      .builder()
      .optionallyWith(deviceAggregatedStatusFilter.map(value => value.unwrap))(
        _.deviceAggregatedStatusFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxSize25.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameFilter.map(value => NameFilter.unwrap(value): java.lang.String)
      )(_.nameFilter)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListDevicesRequest.ReadOnly =
    zio.aws.panorama.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListDevicesRequest =
      zio.aws.panorama.model.ListDevicesRequest(
        deviceAggregatedStatusFilter.map(value => value),
        maxResults.map(value => value),
        nameFilter.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def deviceAggregatedStatusFilter
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus]
    def maxResults: Optional[MaxSize25]
    def nameFilter: Optional[NameFilter]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.panorama.model.ListDevicesSortBy]
    def sortOrder: Optional[zio.aws.panorama.model.SortOrder]
    def getDeviceAggregatedStatusFilter
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceAggregatedStatus] =
      AwsError.unwrapOptionField(
        "deviceAggregatedStatusFilter",
        deviceAggregatedStatusFilter
      )
    def getMaxResults: ZIO[Any, AwsError, MaxSize25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameFilter: ZIO[Any, AwsError, NameFilter] =
      AwsError.unwrapOptionField("nameFilter", nameFilter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.panorama.model.ListDevicesSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.panorama.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListDevicesRequest
  ) extends zio.aws.panorama.model.ListDevicesRequest.ReadOnly {
    override val deviceAggregatedStatusFilter
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceAggregatedStatusFilter())
        .map(value => zio.aws.panorama.model.DeviceAggregatedStatus.wrap(value))
    override val maxResults: Optional[MaxSize25] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.panorama.model.primitives.MaxSize25(value))
    override val nameFilter: Optional[NameFilter] = zio.aws.core.internal
      .optionalFromNullable(impl.nameFilter())
      .map(value => zio.aws.panorama.model.primitives.NameFilter(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.panorama.model.ListDevicesSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.panorama.model.ListDevicesSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.panorama.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.panorama.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListDevicesRequest
  ): zio.aws.panorama.model.ListDevicesRequest.ReadOnly = new Wrapper(impl)
}
