package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDevicesResponse(
    devices: Iterable[zio.aws.panorama.model.Device],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListDevicesResponse = {
    import ListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListDevicesResponse
      .builder()
      .devices(devices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListDevicesResponse.ReadOnly =
    zio.aws.panorama.model.ListDevicesResponse.wrap(buildAwsValue())
}
object ListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListDevicesResponse =
      zio.aws.panorama.model.ListDevicesResponse(
        devices.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def devices: List[zio.aws.panorama.model.Device.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDevices
        : ZIO[Any, Nothing, List[zio.aws.panorama.model.Device.ReadOnly]] =
      ZIO.succeed(devices)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListDevicesResponse
  ) extends zio.aws.panorama.model.ListDevicesResponse.ReadOnly {
    override val devices: List[zio.aws.panorama.model.Device.ReadOnly] = impl
      .devices()
      .asScala
      .map { item =>
        zio.aws.panorama.model.Device.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListDevicesResponse
  ): zio.aws.panorama.model.ListDevicesResponse.ReadOnly = new Wrapper(impl)
}
