package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNodeFromTemplateJobsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    nodeFromTemplateJobs: Iterable[zio.aws.panorama.model.NodeFromTemplateJob]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse = {
    import ListNodeFromTemplateJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .nodeFromTemplateJobs(nodeFromTemplateJobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly =
    zio.aws.panorama.model.ListNodeFromTemplateJobsResponse
      .wrap(buildAwsValue())
}
object ListNodeFromTemplateJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListNodeFromTemplateJobsResponse =
      zio.aws.panorama.model.ListNodeFromTemplateJobsResponse(
        nextToken.map(value => value),
        nodeFromTemplateJobs.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def nodeFromTemplateJobs
        : List[zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNodeFromTemplateJobs: ZIO[Any, Nothing, List[
      zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly
    ]] = ZIO.succeed(nodeFromTemplateJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse
  ) extends zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val nodeFromTemplateJobs
        : List[zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly] = impl
      .nodeFromTemplateJobs()
      .asScala
      .map { item =>
        zio.aws.panorama.model.NodeFromTemplateJob.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse
  ): zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly =
    new Wrapper(impl)
}
