package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  Token,
  NodePackageName,
  NodePackageVersion,
  MaxSize25,
  PackageOwnerAccount,
  NodePackagePatchVersion
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNodesRequest(
    category: Optional[zio.aws.panorama.model.NodeCategory] = Optional.Absent,
    maxResults: Optional[MaxSize25] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageName: Optional[NodePackageName] = Optional.Absent,
    packageVersion: Optional[NodePackageVersion] = Optional.Absent,
    patchVersion: Optional[NodePackagePatchVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListNodesRequest = {
    import ListNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListNodesRequest
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        maxResults.map(value => MaxSize25.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .optionallyWith(
        packageName.map(value =>
          NodePackageName.unwrap(value): java.lang.String
        )
      )(_.packageName)
      .optionallyWith(
        packageVersion.map(value =>
          NodePackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        patchVersion.map(value =>
          NodePackagePatchVersion.unwrap(value): java.lang.String
        )
      )(_.patchVersion)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListNodesRequest.ReadOnly =
    zio.aws.panorama.model.ListNodesRequest.wrap(buildAwsValue())
}
object ListNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListNodesRequest =
      zio.aws.panorama.model.ListNodesRequest(
        category.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ownerAccount.map(value => value),
        packageName.map(value => value),
        packageVersion.map(value => value),
        patchVersion.map(value => value)
      )
    def category: Optional[zio.aws.panorama.model.NodeCategory]
    def maxResults: Optional[MaxSize25]
    def nextToken: Optional[Token]
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageName: Optional[NodePackageName]
    def packageVersion: Optional[NodePackageVersion]
    def patchVersion: Optional[NodePackagePatchVersion]
    def getCategory: ZIO[Any, AwsError, zio.aws.panorama.model.NodeCategory] =
      AwsError.unwrapOptionField("category", category)
    def getMaxResults: ZIO[Any, AwsError, MaxSize25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageName: ZIO[Any, AwsError, NodePackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackageVersion: ZIO[Any, AwsError, NodePackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getPatchVersion: ZIO[Any, AwsError, NodePackagePatchVersion] =
      AwsError.unwrapOptionField("patchVersion", patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListNodesRequest
  ) extends zio.aws.panorama.model.ListNodesRequest.ReadOnly {
    override val category: Optional[zio.aws.panorama.model.NodeCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value => zio.aws.panorama.model.NodeCategory.wrap(value))
    override val maxResults: Optional[MaxSize25] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.panorama.model.primitives.MaxSize25(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.Token(value))
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageName: Optional[NodePackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.panorama.model.primitives.NodePackageName(value))
    override val packageVersion: Optional[NodePackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackageVersion(value)
        )
    override val patchVersion: Optional[NodePackagePatchVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackagePatchVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListNodesRequest
  ): zio.aws.panorama.model.ListNodesRequest.ReadOnly = new Wrapper(impl)
}
