package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.Token
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNodesResponse(
    nextToken: Optional[Token] = Optional.Absent,
    nodes: Optional[Iterable[zio.aws.panorama.model.Node]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListNodesResponse = {
    import ListNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListNodesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListNodesResponse.ReadOnly =
    zio.aws.panorama.model.ListNodesResponse.wrap(buildAwsValue())
}
object ListNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListNodesResponse =
      zio.aws.panorama.model.ListNodesResponse(
        nextToken.map(value => value),
        nodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def nodes: Optional[List[zio.aws.panorama.model.Node.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.panorama.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListNodesResponse
  ) extends zio.aws.panorama.model.ListNodesResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.Token(value))
    override val nodes: Optional[List[zio.aws.panorama.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.Node.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListNodesResponse
  ): zio.aws.panorama.model.ListNodesResponse.ReadOnly = new Wrapper(impl)
}
