package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPackageImportJobsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    packageImportJobs: Iterable[zio.aws.panorama.model.PackageImportJob]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse = {
    import ListPackageImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .packageImportJobs(packageImportJobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly =
    zio.aws.panorama.model.ListPackageImportJobsResponse.wrap(buildAwsValue())
}
object ListPackageImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListPackageImportJobsResponse =
      zio.aws.panorama.model.ListPackageImportJobsResponse(
        nextToken.map(value => value),
        packageImportJobs.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def packageImportJobs
        : List[zio.aws.panorama.model.PackageImportJob.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackageImportJobs: ZIO[Any, Nothing, List[
      zio.aws.panorama.model.PackageImportJob.ReadOnly
    ]] = ZIO.succeed(packageImportJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse
  ) extends zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val packageImportJobs
        : List[zio.aws.panorama.model.PackageImportJob.ReadOnly] = impl
      .packageImportJobs()
      .asScala
      .map { item =>
        zio.aws.panorama.model.PackageImportJob.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse
  ): zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
