package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{Token, MaxSize25}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPackagesRequest(
    maxResults: Optional[MaxSize25] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListPackagesRequest = {
    import ListPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListPackagesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxSize25.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListPackagesRequest.ReadOnly =
    zio.aws.panorama.model.ListPackagesRequest.wrap(buildAwsValue())
}
object ListPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListPackagesRequest =
      zio.aws.panorama.model.ListPackagesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxSize25]
    def nextToken: Optional[Token]
    def getMaxResults: ZIO[Any, AwsError, MaxSize25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListPackagesRequest
  ) extends zio.aws.panorama.model.ListPackagesRequest.ReadOnly {
    override val maxResults: Optional[MaxSize25] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.panorama.model.primitives.MaxSize25(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListPackagesRequest
  ): zio.aws.panorama.model.ListPackagesRequest.ReadOnly = new Wrapper(impl)
}
