package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPackagesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    packages: Optional[Iterable[zio.aws.panorama.model.PackageListItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListPackagesResponse = {
    import ListPackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListPackagesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        packages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packages)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListPackagesResponse.ReadOnly =
    zio.aws.panorama.model.ListPackagesResponse.wrap(buildAwsValue())
}
object ListPackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListPackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListPackagesResponse =
      zio.aws.panorama.model.ListPackagesResponse(
        nextToken.map(value => value),
        packages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def packages
        : Optional[List[zio.aws.panorama.model.PackageListItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackages: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.PackageListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("packages", packages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListPackagesResponse
  ) extends zio.aws.panorama.model.ListPackagesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val packages
        : Optional[List[zio.aws.panorama.model.PackageListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.PackageListItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListPackagesResponse
  ): zio.aws.panorama.model.ListPackagesResponse.ReadOnly = new Wrapper(impl)
}
