package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.panorama.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListTagsForResourceRequest =
      zio.aws.panorama.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest
  ) extends zio.aws.panorama.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.panorama.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest
  ): zio.aws.panorama.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
