package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ManifestOverridesPayloadData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManifestOverridesPayload(
    payloadData: Optional[ManifestOverridesPayloadData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload = {
    import ManifestOverridesPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload
      .builder()
      .optionallyWith(
        payloadData.map(value =>
          ManifestOverridesPayloadData.unwrap(value): java.lang.String
        )
      )(_.payloadData)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly =
    zio.aws.panorama.model.ManifestOverridesPayload.wrap(buildAwsValue())
}
object ManifestOverridesPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ManifestOverridesPayload =
      zio.aws.panorama.model
        .ManifestOverridesPayload(payloadData.map(value => value))
    def payloadData: Optional[ManifestOverridesPayloadData]
    def getPayloadData: ZIO[Any, AwsError, ManifestOverridesPayloadData] =
      AwsError.unwrapOptionField("payloadData", payloadData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload
  ) extends zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly {
    override val payloadData: Optional[ManifestOverridesPayloadData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadData())
        .map(value =>
          zio.aws.panorama.model.primitives.ManifestOverridesPayloadData(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload
  ): zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly = new Wrapper(
    impl
  )
}
