package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ManifestPayloadData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManifestPayload(
    payloadData: Optional[ManifestPayloadData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ManifestPayload = {
    import ManifestPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ManifestPayload
      .builder()
      .optionallyWith(
        payloadData.map(value =>
          ManifestPayloadData.unwrap(value): java.lang.String
        )
      )(_.payloadData)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ManifestPayload.ReadOnly =
    zio.aws.panorama.model.ManifestPayload.wrap(buildAwsValue())
}
object ManifestPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ManifestPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ManifestPayload =
      zio.aws.panorama.model.ManifestPayload(payloadData.map(value => value))
    def payloadData: Optional[ManifestPayloadData]
    def getPayloadData: ZIO[Any, AwsError, ManifestPayloadData] =
      AwsError.unwrapOptionField("payloadData", payloadData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ManifestPayload
  ) extends zio.aws.panorama.model.ManifestPayload.ReadOnly {
    override val payloadData: Optional[ManifestPayloadData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadData())
        .map(value =>
          zio.aws.panorama.model.primitives.ManifestPayloadData(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ManifestPayload
  ): zio.aws.panorama.model.ManifestPayload.ReadOnly = new Wrapper(impl)
}
