package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait NetworkConnectionStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus
}
object NetworkConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus
  ): zio.aws.panorama.model.NetworkConnectionStatus = value match {
    case software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.NOT_CONNECTED =>
      val r = NOT_CONNECTED
      r
    case software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.CONNECTING =>
      val r = CONNECTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.NetworkConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus =
      software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.panorama.model.NetworkConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus =
      software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.CONNECTED
  }
  case object NOT_CONNECTED
      extends zio.aws.panorama.model.NetworkConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus =
      software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.NOT_CONNECTED
  }
  case object CONNECTING
      extends zio.aws.panorama.model.NetworkConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus =
      software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus.CONNECTING
  }
}
