package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkPayload(
    ethernet0: Optional[zio.aws.panorama.model.EthernetPayload] =
      Optional.Absent,
    ethernet1: Optional[zio.aws.panorama.model.EthernetPayload] =
      Optional.Absent,
    ntp: Optional[zio.aws.panorama.model.NtpPayload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NetworkPayload = {
    import NetworkPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NetworkPayload
      .builder()
      .optionallyWith(ethernet0.map(value => value.buildAwsValue()))(
        _.ethernet0
      )
      .optionallyWith(ethernet1.map(value => value.buildAwsValue()))(
        _.ethernet1
      )
      .optionallyWith(ntp.map(value => value.buildAwsValue()))(_.ntp)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NetworkPayload.ReadOnly =
    zio.aws.panorama.model.NetworkPayload.wrap(buildAwsValue())
}
object NetworkPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NetworkPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NetworkPayload =
      zio.aws.panorama.model.NetworkPayload(
        ethernet0.map(value => value.asEditable),
        ethernet1.map(value => value.asEditable),
        ntp.map(value => value.asEditable)
      )
    def ethernet0: Optional[zio.aws.panorama.model.EthernetPayload.ReadOnly]
    def ethernet1: Optional[zio.aws.panorama.model.EthernetPayload.ReadOnly]
    def ntp: Optional[zio.aws.panorama.model.NtpPayload.ReadOnly]
    def getEthernet0
        : ZIO[Any, AwsError, zio.aws.panorama.model.EthernetPayload.ReadOnly] =
      AwsError.unwrapOptionField("ethernet0", ethernet0)
    def getEthernet1
        : ZIO[Any, AwsError, zio.aws.panorama.model.EthernetPayload.ReadOnly] =
      AwsError.unwrapOptionField("ethernet1", ethernet1)
    def getNtp: ZIO[Any, AwsError, zio.aws.panorama.model.NtpPayload.ReadOnly] =
      AwsError.unwrapOptionField("ntp", ntp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NetworkPayload
  ) extends zio.aws.panorama.model.NetworkPayload.ReadOnly {
    override val ethernet0
        : Optional[zio.aws.panorama.model.EthernetPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ethernet0())
        .map(value => zio.aws.panorama.model.EthernetPayload.wrap(value))
    override val ethernet1
        : Optional[zio.aws.panorama.model.EthernetPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ethernet1())
        .map(value => zio.aws.panorama.model.EthernetPayload.wrap(value))
    override val ntp: Optional[zio.aws.panorama.model.NtpPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ntp())
        .map(value => zio.aws.panorama.model.NtpPayload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NetworkPayload
  ): zio.aws.panorama.model.NetworkPayload.ReadOnly = new Wrapper(impl)
}
