package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.LastUpdatedTime
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class NetworkStatus(
    ethernet0Status: Optional[zio.aws.panorama.model.EthernetStatus] =
      Optional.Absent,
    ethernet1Status: Optional[zio.aws.panorama.model.EthernetStatus] =
      Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent,
    ntpStatus: Optional[zio.aws.panorama.model.NtpStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NetworkStatus = {
    import NetworkStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NetworkStatus
      .builder()
      .optionallyWith(ethernet0Status.map(value => value.buildAwsValue()))(
        _.ethernet0Status
      )
      .optionallyWith(ethernet1Status.map(value => value.buildAwsValue()))(
        _.ethernet1Status
      )
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(ntpStatus.map(value => value.buildAwsValue()))(
        _.ntpStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NetworkStatus.ReadOnly =
    zio.aws.panorama.model.NetworkStatus.wrap(buildAwsValue())
}
object NetworkStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NetworkStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NetworkStatus =
      zio.aws.panorama.model.NetworkStatus(
        ethernet0Status.map(value => value.asEditable),
        ethernet1Status.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        ntpStatus.map(value => value.asEditable)
      )
    def ethernet0Status
        : Optional[zio.aws.panorama.model.EthernetStatus.ReadOnly]
    def ethernet1Status
        : Optional[zio.aws.panorama.model.EthernetStatus.ReadOnly]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def ntpStatus: Optional[zio.aws.panorama.model.NtpStatus.ReadOnly]
    def getEthernet0Status
        : ZIO[Any, AwsError, zio.aws.panorama.model.EthernetStatus.ReadOnly] =
      AwsError.unwrapOptionField("ethernet0Status", ethernet0Status)
    def getEthernet1Status
        : ZIO[Any, AwsError, zio.aws.panorama.model.EthernetStatus.ReadOnly] =
      AwsError.unwrapOptionField("ethernet1Status", ethernet1Status)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getNtpStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.NtpStatus.ReadOnly] =
      AwsError.unwrapOptionField("ntpStatus", ntpStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NetworkStatus
  ) extends zio.aws.panorama.model.NetworkStatus.ReadOnly {
    override val ethernet0Status
        : Optional[zio.aws.panorama.model.EthernetStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ethernet0Status())
        .map(value => zio.aws.panorama.model.EthernetStatus.wrap(value))
    override val ethernet1Status
        : Optional[zio.aws.panorama.model.EthernetStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ethernet1Status())
        .map(value => zio.aws.panorama.model.EthernetStatus.wrap(value))
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.panorama.model.primitives.LastUpdatedTime(value))
    override val ntpStatus
        : Optional[zio.aws.panorama.model.NtpStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ntpStatus())
        .map(value => zio.aws.panorama.model.NtpStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NetworkStatus
  ): zio.aws.panorama.model.NetworkStatus.ReadOnly = new Wrapper(impl)
}
