package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodePackageId,
  NodePackageArn,
  NodePackageVersion,
  Description,
  NodeName,
  PackageOwnerAccount,
  TimeStamp,
  NodePackagePatchVersion,
  NodeId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Node(
    category: zio.aws.panorama.model.NodeCategory,
    createdTime: TimeStamp,
    description: Optional[Description] = Optional.Absent,
    name: NodeName,
    nodeId: NodeId,
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageArn: Optional[NodePackageArn] = Optional.Absent,
    packageId: NodePackageId,
    packageName: NodePackageName,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion
) {
  def buildAwsValue(): software.amazon.awssdk.services.panorama.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.Node
      .builder()
      .category(category.unwrap)
      .createdTime(TimeStamp.unwrap(createdTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(NodeName.unwrap(name): java.lang.String)
      .nodeId(NodeId.unwrap(nodeId): java.lang.String)
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .optionallyWith(
        packageArn.map(value => NodePackageArn.unwrap(value): java.lang.String)
      )(_.packageArn)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.Node.ReadOnly =
    zio.aws.panorama.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.panorama.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.Node = zio.aws.panorama.model.Node(
      category,
      createdTime,
      description.map(value => value),
      name,
      nodeId,
      ownerAccount.map(value => value),
      packageArn.map(value => value),
      packageId,
      packageName,
      packageVersion,
      patchVersion
    )
    def category: zio.aws.panorama.model.NodeCategory
    def createdTime: TimeStamp
    def description: Optional[Description]
    def name: NodeName
    def nodeId: NodeId
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageArn: Optional[NodePackageArn]
    def packageId: NodePackageId
    def packageName: NodePackageName
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def getCategory: ZIO[Any, Nothing, zio.aws.panorama.model.NodeCategory] =
      ZIO.succeed(category)
    def getCreatedTime: ZIO[Any, Nothing, TimeStamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(name)
    def getNodeId: ZIO[Any, Nothing, NodeId] = ZIO.succeed(nodeId)
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageArn: ZIO[Any, AwsError, NodePackageArn] =
      AwsError.unwrapOptionField("packageArn", packageArn)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.Node
  ) extends zio.aws.panorama.model.Node.ReadOnly {
    override val category: zio.aws.panorama.model.NodeCategory =
      zio.aws.panorama.model.NodeCategory.wrap(impl.category())
    override val createdTime: TimeStamp =
      zio.aws.panorama.model.primitives.TimeStamp(impl.createdTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val name: NodeName =
      zio.aws.panorama.model.primitives.NodeName(impl.name())
    override val nodeId: NodeId =
      zio.aws.panorama.model.primitives.NodeId(impl.nodeId())
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageArn: Optional[NodePackageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.packageArn())
      .map(value => zio.aws.panorama.model.primitives.NodePackageArn(value))
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.Node
  ): zio.aws.panorama.model.Node.ReadOnly = new Wrapper(impl)
}
