package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait NodeCategory {
  def unwrap: software.amazon.awssdk.services.panorama.model.NodeCategory
}
object NodeCategory {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.NodeCategory
  ): zio.aws.panorama.model.NodeCategory = value match {
    case software.amazon.awssdk.services.panorama.model.NodeCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.NodeCategory.BUSINESS_LOGIC =>
      val r = BUSINESS_LOGIC
      r
    case software.amazon.awssdk.services.panorama.model.NodeCategory.ML_MODEL =>
      val r = ML_MODEL
      r
    case software.amazon.awssdk.services.panorama.model.NodeCategory.MEDIA_SOURCE =>
      val r = MEDIA_SOURCE
      r
    case software.amazon.awssdk.services.panorama.model.NodeCategory.MEDIA_SINK =>
      val r = MEDIA_SINK
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.NodeCategory {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeCategory =
      software.amazon.awssdk.services.panorama.model.NodeCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object BUSINESS_LOGIC extends zio.aws.panorama.model.NodeCategory {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeCategory =
      software.amazon.awssdk.services.panorama.model.NodeCategory.BUSINESS_LOGIC
  }
  case object ML_MODEL extends zio.aws.panorama.model.NodeCategory {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeCategory =
      software.amazon.awssdk.services.panorama.model.NodeCategory.ML_MODEL
  }
  case object MEDIA_SOURCE extends zio.aws.panorama.model.NodeCategory {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeCategory =
      software.amazon.awssdk.services.panorama.model.NodeCategory.MEDIA_SOURCE
  }
  case object MEDIA_SINK extends zio.aws.panorama.model.NodeCategory {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeCategory =
      software.amazon.awssdk.services.panorama.model.NodeCategory.MEDIA_SINK
  }
}
