package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodeFromTemplateJobStatusMessage,
  NodeName,
  JobId,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class NodeFromTemplateJob(
    createdTime: Optional[CreatedTime] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    nodeName: Optional[NodeName] = Optional.Absent,
    status: Optional[zio.aws.panorama.model.NodeFromTemplateJobStatus] =
      Optional.Absent,
    statusMessage: Optional[NodeFromTemplateJobStatusMessage] = Optional.Absent,
    templateType: Optional[zio.aws.panorama.model.TemplateType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob = {
    import NodeFromTemplateJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob
      .builder()
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        nodeName.map(value => NodeName.unwrap(value): java.lang.String)
      )(_.nodeName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          NodeFromTemplateJobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(templateType.map(value => value.unwrap))(_.templateType)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly =
    zio.aws.panorama.model.NodeFromTemplateJob.wrap(buildAwsValue())
}
object NodeFromTemplateJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeFromTemplateJob =
      zio.aws.panorama.model.NodeFromTemplateJob(
        createdTime.map(value => value),
        jobId.map(value => value),
        nodeName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        templateType.map(value => value)
      )
    def createdTime: Optional[CreatedTime]
    def jobId: Optional[JobId]
    def nodeName: Optional[NodeName]
    def status: Optional[zio.aws.panorama.model.NodeFromTemplateJobStatus]
    def statusMessage: Optional[NodeFromTemplateJobStatusMessage]
    def templateType: Optional[zio.aws.panorama.model.TemplateType]
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getNodeName: ZIO[Any, AwsError, NodeName] =
      AwsError.unwrapOptionField("nodeName", nodeName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.NodeFromTemplateJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, NodeFromTemplateJobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateType
        : ZIO[Any, AwsError, zio.aws.panorama.model.TemplateType] =
      AwsError.unwrapOptionField("templateType", templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob
  ) extends zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly {
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.CreatedTime(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.panorama.model.primitives.JobId(value))
    override val nodeName: Optional[NodeName] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeName())
      .map(value => zio.aws.panorama.model.primitives.NodeName(value))
    override val status
        : Optional[zio.aws.panorama.model.NodeFromTemplateJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.panorama.model.NodeFromTemplateJobStatus.wrap(value)
        )
    override val statusMessage: Optional[NodeFromTemplateJobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.panorama.model.primitives
            .NodeFromTemplateJobStatusMessage(value)
        )
    override val templateType: Optional[zio.aws.panorama.model.TemplateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateType())
        .map(value => zio.aws.panorama.model.TemplateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob
  ): zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly = new Wrapper(impl)
}
