package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait NodeFromTemplateJobStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus
}
object NodeFromTemplateJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus
  ): zio.aws.panorama.model.NodeFromTemplateJobStatus = value match {
    case software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.NodeFromTemplateJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus =
      software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.panorama.model.NodeFromTemplateJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus =
      software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.PENDING
  }
  case object SUCCEEDED
      extends zio.aws.panorama.model.NodeFromTemplateJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus =
      software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.panorama.model.NodeFromTemplateJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus =
      software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus.FAILED
  }
}
