package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  PortName,
  MaxConnections,
  Description,
  PortDefaultValue
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NodeInputPort(
    defaultValue: Optional[PortDefaultValue] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    maxConnections: Optional[MaxConnections] = Optional.Absent,
    name: Optional[PortName] = Optional.Absent,
    `type`: Optional[zio.aws.panorama.model.PortType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeInputPort = {
    import NodeInputPort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeInputPort
      .builder()
      .optionallyWith(
        defaultValue.map(value =>
          PortDefaultValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        maxConnections.map(value => MaxConnections.unwrap(value): Integer)
      )(_.maxConnections)
      .optionallyWith(
        name.map(value => PortName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeInputPort.ReadOnly =
    zio.aws.panorama.model.NodeInputPort.wrap(buildAwsValue())
}
object NodeInputPort {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeInputPort
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeInputPort =
      zio.aws.panorama.model.NodeInputPort(
        defaultValue.map(value => value),
        description.map(value => value),
        maxConnections.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def defaultValue: Optional[PortDefaultValue]
    def description: Optional[Description]
    def maxConnections: Optional[MaxConnections]
    def name: Optional[PortName]
    def `type`: Optional[zio.aws.panorama.model.PortType]
    def getDefaultValue: ZIO[Any, AwsError, PortDefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMaxConnections: ZIO[Any, AwsError, MaxConnections] =
      AwsError.unwrapOptionField("maxConnections", maxConnections)
    def getName: ZIO[Any, AwsError, PortName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.panorama.model.PortType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeInputPort
  ) extends zio.aws.panorama.model.NodeInputPort.ReadOnly {
    override val defaultValue: Optional[PortDefaultValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value => zio.aws.panorama.model.primitives.PortDefaultValue(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val maxConnections: Optional[MaxConnections] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConnections())
        .map(value => zio.aws.panorama.model.primitives.MaxConnections(value))
    override val name: Optional[PortName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.panorama.model.primitives.PortName(value))
    override val `type`: Optional[zio.aws.panorama.model.PortType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.panorama.model.PortType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeInputPort
  ): zio.aws.panorama.model.NodeInputPort.ReadOnly = new Wrapper(impl)
}
