package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodeInstanceId,
  NodePackageVersion,
  NodeName,
  NodePackagePatchVersion,
  NodeId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeInstance(
    currentStatus: zio.aws.panorama.model.NodeInstanceStatus,
    nodeId: Optional[NodeId] = Optional.Absent,
    nodeInstanceId: NodeInstanceId,
    nodeName: Optional[NodeName] = Optional.Absent,
    packageName: Optional[NodePackageName] = Optional.Absent,
    packagePatchVersion: Optional[NodePackagePatchVersion] = Optional.Absent,
    packageVersion: Optional[NodePackageVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeInstance = {
    import NodeInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeInstance
      .builder()
      .currentStatus(currentStatus.unwrap)
      .optionallyWith(
        nodeId.map(value => NodeId.unwrap(value): java.lang.String)
      )(_.nodeId)
      .nodeInstanceId(NodeInstanceId.unwrap(nodeInstanceId): java.lang.String)
      .optionallyWith(
        nodeName.map(value => NodeName.unwrap(value): java.lang.String)
      )(_.nodeName)
      .optionallyWith(
        packageName.map(value =>
          NodePackageName.unwrap(value): java.lang.String
        )
      )(_.packageName)
      .optionallyWith(
        packagePatchVersion.map(value =>
          NodePackagePatchVersion.unwrap(value): java.lang.String
        )
      )(_.packagePatchVersion)
      .optionallyWith(
        packageVersion.map(value =>
          NodePackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeInstance.ReadOnly =
    zio.aws.panorama.model.NodeInstance.wrap(buildAwsValue())
}
object NodeInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeInstance =
      zio.aws.panorama.model.NodeInstance(
        currentStatus,
        nodeId.map(value => value),
        nodeInstanceId,
        nodeName.map(value => value),
        packageName.map(value => value),
        packagePatchVersion.map(value => value),
        packageVersion.map(value => value)
      )
    def currentStatus: zio.aws.panorama.model.NodeInstanceStatus
    def nodeId: Optional[NodeId]
    def nodeInstanceId: NodeInstanceId
    def nodeName: Optional[NodeName]
    def packageName: Optional[NodePackageName]
    def packagePatchVersion: Optional[NodePackagePatchVersion]
    def packageVersion: Optional[NodePackageVersion]
    def getCurrentStatus
        : ZIO[Any, Nothing, zio.aws.panorama.model.NodeInstanceStatus] =
      ZIO.succeed(currentStatus)
    def getNodeId: ZIO[Any, AwsError, NodeId] =
      AwsError.unwrapOptionField("nodeId", nodeId)
    def getNodeInstanceId: ZIO[Any, Nothing, NodeInstanceId] =
      ZIO.succeed(nodeInstanceId)
    def getNodeName: ZIO[Any, AwsError, NodeName] =
      AwsError.unwrapOptionField("nodeName", nodeName)
    def getPackageName: ZIO[Any, AwsError, NodePackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackagePatchVersion: ZIO[Any, AwsError, NodePackagePatchVersion] =
      AwsError.unwrapOptionField("packagePatchVersion", packagePatchVersion)
    def getPackageVersion: ZIO[Any, AwsError, NodePackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeInstance
  ) extends zio.aws.panorama.model.NodeInstance.ReadOnly {
    override val currentStatus: zio.aws.panorama.model.NodeInstanceStatus =
      zio.aws.panorama.model.NodeInstanceStatus.wrap(impl.currentStatus())
    override val nodeId: Optional[NodeId] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeId())
      .map(value => zio.aws.panorama.model.primitives.NodeId(value))
    override val nodeInstanceId: NodeInstanceId =
      zio.aws.panorama.model.primitives.NodeInstanceId(impl.nodeInstanceId())
    override val nodeName: Optional[NodeName] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeName())
      .map(value => zio.aws.panorama.model.primitives.NodeName(value))
    override val packageName: Optional[NodePackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.panorama.model.primitives.NodePackageName(value))
    override val packagePatchVersion: Optional[NodePackagePatchVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packagePatchVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackagePatchVersion(value)
        )
    override val packageVersion: Optional[NodePackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackageVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeInstance
  ): zio.aws.panorama.model.NodeInstance.ReadOnly = new Wrapper(impl)
}
