package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait NodeInstanceStatus {
  def unwrap: software.amazon.awssdk.services.panorama.model.NodeInstanceStatus
}
object NodeInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.NodeInstanceStatus
  ): zio.aws.panorama.model.NodeInstanceStatus = value match {
    case software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
    case software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.PAUSED =>
      val r = PAUSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.NodeInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeInstanceStatus =
      software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.panorama.model.NodeInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeInstanceStatus =
      software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.RUNNING
  }
  case object ERROR extends zio.aws.panorama.model.NodeInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeInstanceStatus =
      software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.ERROR
  }
  case object NOT_AVAILABLE extends zio.aws.panorama.model.NodeInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeInstanceStatus =
      software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.NOT_AVAILABLE
  }
  case object PAUSED extends zio.aws.panorama.model.NodeInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeInstanceStatus =
      software.amazon.awssdk.services.panorama.model.NodeInstanceStatus.PAUSED
  }
}
