package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NodeInterface(
    inputs: Iterable[zio.aws.panorama.model.NodeInputPort],
    outputs: Iterable[zio.aws.panorama.model.NodeOutputPort]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeInterface = {
    import NodeInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeInterface
      .builder()
      .inputs(inputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeInterface.ReadOnly =
    zio.aws.panorama.model.NodeInterface.wrap(buildAwsValue())
}
object NodeInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeInterface =
      zio.aws.panorama.model.NodeInterface(
        inputs.map { item =>
          item.asEditable
        },
        outputs.map { item =>
          item.asEditable
        }
      )
    def inputs: List[zio.aws.panorama.model.NodeInputPort.ReadOnly]
    def outputs: List[zio.aws.panorama.model.NodeOutputPort.ReadOnly]
    def getInputs: ZIO[Any, Nothing, List[
      zio.aws.panorama.model.NodeInputPort.ReadOnly
    ]] = ZIO.succeed(inputs)
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.panorama.model.NodeOutputPort.ReadOnly
    ]] = ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeInterface
  ) extends zio.aws.panorama.model.NodeInterface.ReadOnly {
    override val inputs: List[zio.aws.panorama.model.NodeInputPort.ReadOnly] =
      impl
        .inputs()
        .asScala
        .map { item =>
          zio.aws.panorama.model.NodeInputPort.wrap(item)
        }
        .toList
    override val outputs: List[zio.aws.panorama.model.NodeOutputPort.ReadOnly] =
      impl
        .outputs()
        .asScala
        .map { item =>
          zio.aws.panorama.model.NodeOutputPort.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeInterface
  ): zio.aws.panorama.model.NodeInterface.ReadOnly = new Wrapper(impl)
}
