package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{PortName, Description}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeOutputPort(
    description: Optional[Description] = Optional.Absent,
    name: Optional[PortName] = Optional.Absent,
    `type`: Optional[zio.aws.panorama.model.PortType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeOutputPort = {
    import NodeOutputPort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeOutputPort
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        name.map(value => PortName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeOutputPort.ReadOnly =
    zio.aws.panorama.model.NodeOutputPort.wrap(buildAwsValue())
}
object NodeOutputPort {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeOutputPort
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeOutputPort =
      zio.aws.panorama.model.NodeOutputPort(
        description.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def description: Optional[Description]
    def name: Optional[PortName]
    def `type`: Optional[zio.aws.panorama.model.PortType]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, PortName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.panorama.model.PortType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeOutputPort
  ) extends zio.aws.panorama.model.NodeOutputPort.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val name: Optional[PortName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.panorama.model.primitives.PortName(value))
    override val `type`: Optional[zio.aws.panorama.model.PortType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.panorama.model.PortType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeOutputPort
  ): zio.aws.panorama.model.NodeOutputPort.ReadOnly = new Wrapper(impl)
}
