package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NodeInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NodeSignal(
    nodeInstanceId: NodeInstanceId,
    signal: zio.aws.panorama.model.NodeSignalValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NodeSignal = {
    import NodeSignal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NodeSignal
      .builder()
      .nodeInstanceId(NodeInstanceId.unwrap(nodeInstanceId): java.lang.String)
      .signal(signal.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NodeSignal.ReadOnly =
    zio.aws.panorama.model.NodeSignal.wrap(buildAwsValue())
}
object NodeSignal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NodeSignal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NodeSignal =
      zio.aws.panorama.model.NodeSignal(nodeInstanceId, signal)
    def nodeInstanceId: NodeInstanceId
    def signal: zio.aws.panorama.model.NodeSignalValue
    def getNodeInstanceId: ZIO[Any, Nothing, NodeInstanceId] =
      ZIO.succeed(nodeInstanceId)
    def getSignal: ZIO[Any, Nothing, zio.aws.panorama.model.NodeSignalValue] =
      ZIO.succeed(signal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NodeSignal
  ) extends zio.aws.panorama.model.NodeSignal.ReadOnly {
    override val nodeInstanceId: NodeInstanceId =
      zio.aws.panorama.model.primitives.NodeInstanceId(impl.nodeInstanceId())
    override val signal: zio.aws.panorama.model.NodeSignalValue =
      zio.aws.panorama.model.NodeSignalValue.wrap(impl.signal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NodeSignal
  ): zio.aws.panorama.model.NodeSignal.ReadOnly = new Wrapper(impl)
}
