package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait NodeSignalValue {
  def unwrap: software.amazon.awssdk.services.panorama.model.NodeSignalValue
}
object NodeSignalValue {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.NodeSignalValue
  ): zio.aws.panorama.model.NodeSignalValue = value match {
    case software.amazon.awssdk.services.panorama.model.NodeSignalValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.NodeSignalValue.PAUSE =>
      val r = PAUSE
      r
    case software.amazon.awssdk.services.panorama.model.NodeSignalValue.RESUME =>
      val r = RESUME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.NodeSignalValue {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeSignalValue =
      software.amazon.awssdk.services.panorama.model.NodeSignalValue.UNKNOWN_TO_SDK_VERSION
  }
  case object PAUSE extends zio.aws.panorama.model.NodeSignalValue {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeSignalValue =
      software.amazon.awssdk.services.panorama.model.NodeSignalValue.PAUSE
  }
  case object RESUME extends zio.aws.panorama.model.NodeSignalValue {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.NodeSignalValue =
      software.amazon.awssdk.services.panorama.model.NodeSignalValue.RESUME
  }
}
