package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.IpAddressOrServerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NtpPayload(ntpServers: Iterable[IpAddressOrServerName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NtpPayload = {
    import NtpPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NtpPayload
      .builder()
      .ntpServers(ntpServers.map { item =>
        IpAddressOrServerName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NtpPayload.ReadOnly =
    zio.aws.panorama.model.NtpPayload.wrap(buildAwsValue())
}
object NtpPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NtpPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NtpPayload =
      zio.aws.panorama.model.NtpPayload(ntpServers)
    def ntpServers: List[IpAddressOrServerName]
    def getNtpServers: ZIO[Any, Nothing, List[IpAddressOrServerName]] =
      ZIO.succeed(ntpServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NtpPayload
  ) extends zio.aws.panorama.model.NtpPayload.ReadOnly {
    override val ntpServers: List[IpAddressOrServerName] = impl
      .ntpServers()
      .asScala
      .map { item =>
        zio.aws.panorama.model.primitives.IpAddressOrServerName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NtpPayload
  ): zio.aws.panorama.model.NtpPayload.ReadOnly = new Wrapper(impl)
}
