package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{NtpServerName, IpAddress}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NtpStatus(
    connectionStatus: Optional[zio.aws.panorama.model.NetworkConnectionStatus] =
      Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    ntpServerName: Optional[NtpServerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.NtpStatus = {
    import NtpStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.NtpStatus
      .builder()
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        ntpServerName.map(value =>
          NtpServerName.unwrap(value): java.lang.String
        )
      )(_.ntpServerName)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.NtpStatus.ReadOnly =
    zio.aws.panorama.model.NtpStatus.wrap(buildAwsValue())
}
object NtpStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.NtpStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.NtpStatus =
      zio.aws.panorama.model.NtpStatus(
        connectionStatus.map(value => value),
        ipAddress.map(value => value),
        ntpServerName.map(value => value)
      )
    def connectionStatus
        : Optional[zio.aws.panorama.model.NetworkConnectionStatus]
    def ipAddress: Optional[IpAddress]
    def ntpServerName: Optional[NtpServerName]
    def getConnectionStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.NetworkConnectionStatus] =
      AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getNtpServerName: ZIO[Any, AwsError, NtpServerName] =
      AwsError.unwrapOptionField("ntpServerName", ntpServerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.NtpStatus
  ) extends zio.aws.panorama.model.NtpStatus.ReadOnly {
    override val connectionStatus
        : Optional[zio.aws.panorama.model.NetworkConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.panorama.model.NetworkConnectionStatus.wrap(value)
        )
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.panorama.model.primitives.IpAddress(value))
    override val ntpServerName: Optional[NtpServerName] = zio.aws.core.internal
      .optionalFromNullable(impl.ntpServerName())
      .map(value => zio.aws.panorama.model.primitives.NtpServerName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.NtpStatus
  ): zio.aws.panorama.model.NtpStatus.ReadOnly = new Wrapper(impl)
}
