package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ImageVersion
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OTAJobConfig(
    allowMajorVersionUpdate: Optional[Boolean] = Optional.Absent,
    imageVersion: ImageVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.OTAJobConfig = {
    import OTAJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.OTAJobConfig
      .builder()
      .optionallyWith(
        allowMajorVersionUpdate.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpdate)
      .imageVersion(ImageVersion.unwrap(imageVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.OTAJobConfig.ReadOnly =
    zio.aws.panorama.model.OTAJobConfig.wrap(buildAwsValue())
}
object OTAJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.OTAJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.OTAJobConfig = zio.aws.panorama.model
      .OTAJobConfig(allowMajorVersionUpdate.map(value => value), imageVersion)
    def allowMajorVersionUpdate: Optional[Boolean]
    def imageVersion: ImageVersion
    def getAllowMajorVersionUpdate: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpdate", allowMajorVersionUpdate)
    def getImageVersion: ZIO[Any, Nothing, ImageVersion] =
      ZIO.succeed(imageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.OTAJobConfig
  ) extends zio.aws.panorama.model.OTAJobConfig.ReadOnly {
    override val allowMajorVersionUpdate: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpdate())
        .map(value => value: Boolean)
    override val imageVersion: ImageVersion =
      zio.aws.panorama.model.primitives.ImageVersion(impl.imageVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.OTAJobConfig
  ): zio.aws.panorama.model.OTAJobConfig.ReadOnly = new Wrapper(impl)
}
