package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{ObjectKey, BucketName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OutPutS3Location(
    bucketName: BucketName,
    objectKey: ObjectKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.OutPutS3Location = {
    import OutPutS3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.OutPutS3Location
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .objectKey(ObjectKey.unwrap(objectKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.OutPutS3Location.ReadOnly =
    zio.aws.panorama.model.OutPutS3Location.wrap(buildAwsValue())
}
object OutPutS3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.OutPutS3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.OutPutS3Location =
      zio.aws.panorama.model.OutPutS3Location(bucketName, objectKey)
    def bucketName: BucketName
    def objectKey: ObjectKey
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getObjectKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(objectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.OutPutS3Location
  ) extends zio.aws.panorama.model.OutPutS3Location.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.panorama.model.primitives.BucketName(impl.bucketName())
    override val objectKey: ObjectKey =
      zio.aws.panorama.model.primitives.ObjectKey(impl.objectKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.OutPutS3Location
  ): zio.aws.panorama.model.OutPutS3Location.ReadOnly = new Wrapper(impl)
}
