package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  PackageImportJobStatusMessage,
  LastUpdatedTime,
  JobId,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PackageImportJob(
    createdTime: Optional[CreatedTime] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    jobType: Optional[zio.aws.panorama.model.PackageImportJobType] =
      Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent,
    status: Optional[zio.aws.panorama.model.PackageImportJobStatus] =
      Optional.Absent,
    statusMessage: Optional[PackageImportJobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageImportJob = {
    import PackageImportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageImportJob
      .builder()
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          PackageImportJobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageImportJob.ReadOnly =
    zio.aws.panorama.model.PackageImportJob.wrap(buildAwsValue())
}
object PackageImportJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageImportJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageImportJob =
      zio.aws.panorama.model.PackageImportJob(
        createdTime.map(value => value),
        jobId.map(value => value),
        jobType.map(value => value),
        lastUpdatedTime.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def createdTime: Optional[CreatedTime]
    def jobId: Optional[JobId]
    def jobType: Optional[zio.aws.panorama.model.PackageImportJobType]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def status: Optional[zio.aws.panorama.model.PackageImportJobStatus]
    def statusMessage: Optional[PackageImportJobStatusMessage]
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobType
        : ZIO[Any, AwsError, zio.aws.panorama.model.PackageImportJobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.PackageImportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, PackageImportJobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJob
  ) extends zio.aws.panorama.model.PackageImportJob.ReadOnly {
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.CreatedTime(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.panorama.model.primitives.JobId(value))
    override val jobType
        : Optional[zio.aws.panorama.model.PackageImportJobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.panorama.model.PackageImportJobType.wrap(value))
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.panorama.model.primitives.LastUpdatedTime(value))
    override val status
        : Optional[zio.aws.panorama.model.PackageImportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.panorama.model.PackageImportJobStatus.wrap(value))
    override val statusMessage: Optional[PackageImportJobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageImportJobStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJob
  ): zio.aws.panorama.model.PackageImportJob.ReadOnly = new Wrapper(impl)
}
