package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PackageImportJobInputConfig(
    packageVersionInputConfig: Optional[
      zio.aws.panorama.model.PackageVersionInputConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig = {
    import PackageImportJobInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig
      .builder()
      .optionallyWith(
        packageVersionInputConfig.map(value => value.buildAwsValue())
      )(_.packageVersionInputConfig)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly =
    zio.aws.panorama.model.PackageImportJobInputConfig.wrap(buildAwsValue())
}
object PackageImportJobInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageImportJobInputConfig =
      zio.aws.panorama.model.PackageImportJobInputConfig(
        packageVersionInputConfig.map(value => value.asEditable)
      )
    def packageVersionInputConfig
        : Optional[zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly]
    def getPackageVersionInputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "packageVersionInputConfig",
      packageVersionInputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig
  ) extends zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly {
    override val packageVersionInputConfig
        : Optional[zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersionInputConfig())
        .map(value =>
          zio.aws.panorama.model.PackageVersionInputConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig
  ): zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly = new Wrapper(
    impl
  )
}
