package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackagePatchVersion,
  NodePackageVersion,
  NodePackageId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PackageImportJobOutput(
    outputS3Location: zio.aws.panorama.model.OutPutS3Location,
    packageId: NodePackageId,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageImportJobOutput = {
    import PackageImportJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageImportJobOutput
      .builder()
      .outputS3Location(outputS3Location.buildAwsValue())
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageImportJobOutput.ReadOnly =
    zio.aws.panorama.model.PackageImportJobOutput.wrap(buildAwsValue())
}
object PackageImportJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageImportJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageImportJobOutput =
      zio.aws.panorama.model.PackageImportJobOutput(
        outputS3Location.asEditable,
        packageId,
        packageVersion,
        patchVersion
      )
    def outputS3Location: zio.aws.panorama.model.OutPutS3Location.ReadOnly
    def packageId: NodePackageId
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def getOutputS3Location
        : ZIO[Any, Nothing, zio.aws.panorama.model.OutPutS3Location.ReadOnly] =
      ZIO.succeed(outputS3Location)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobOutput
  ) extends zio.aws.panorama.model.PackageImportJobOutput.ReadOnly {
    override val outputS3Location
        : zio.aws.panorama.model.OutPutS3Location.ReadOnly =
      zio.aws.panorama.model.OutPutS3Location.wrap(impl.outputS3Location())
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobOutput
  ): zio.aws.panorama.model.PackageImportJobOutput.ReadOnly = new Wrapper(impl)
}
