package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PackageImportJobOutputConfig(
    packageVersionOutputConfig: Optional[
      zio.aws.panorama.model.PackageVersionOutputConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig = {
    import PackageImportJobOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig
      .builder()
      .optionallyWith(
        packageVersionOutputConfig.map(value => value.buildAwsValue())
      )(_.packageVersionOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly =
    zio.aws.panorama.model.PackageImportJobOutputConfig.wrap(buildAwsValue())
}
object PackageImportJobOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageImportJobOutputConfig =
      zio.aws.panorama.model.PackageImportJobOutputConfig(
        packageVersionOutputConfig.map(value => value.asEditable)
      )
    def packageVersionOutputConfig
        : Optional[zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly]
    def getPackageVersionOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "packageVersionOutputConfig",
      packageVersionOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig
  ) extends zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly {
    override val packageVersionOutputConfig
        : Optional[zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersionOutputConfig())
        .map(value =>
          zio.aws.panorama.model.PackageVersionOutputConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig
  ): zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
