package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait PackageImportJobStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.PackageImportJobStatus
}
object PackageImportJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.PackageImportJobStatus
  ): zio.aws.panorama.model.PackageImportJobStatus = value match {
    case software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.PackageImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobStatus =
      software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.panorama.model.PackageImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobStatus =
      software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.PENDING
  }
  case object SUCCEEDED extends zio.aws.panorama.model.PackageImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobStatus =
      software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.panorama.model.PackageImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobStatus =
      software.amazon.awssdk.services.panorama.model.PackageImportJobStatus.FAILED
  }
}
