package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait PackageImportJobType {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.PackageImportJobType
}
object PackageImportJobType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.PackageImportJobType
  ): zio.aws.panorama.model.PackageImportJobType = value match {
    case software.amazon.awssdk.services.panorama.model.PackageImportJobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.PackageImportJobType.NODE_PACKAGE_VERSION =>
      val r = NODE_PACKAGE_VERSION
      r
    case software.amazon.awssdk.services.panorama.model.PackageImportJobType.MARKETPLACE_NODE_PACKAGE_VERSION =>
      val r = MARKETPLACE_NODE_PACKAGE_VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.PackageImportJobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobType =
      software.amazon.awssdk.services.panorama.model.PackageImportJobType.UNKNOWN_TO_SDK_VERSION
  }
  case object NODE_PACKAGE_VERSION
      extends zio.aws.panorama.model.PackageImportJobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobType =
      software.amazon.awssdk.services.panorama.model.PackageImportJobType.NODE_PACKAGE_VERSION
  }
  case object MARKETPLACE_NODE_PACKAGE_VERSION
      extends zio.aws.panorama.model.PackageImportJobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageImportJobType =
      software.amazon.awssdk.services.panorama.model.PackageImportJobType.MARKETPLACE_NODE_PACKAGE_VERSION
  }
}
