package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodePackageId,
  NodePackageArn,
  TagValue,
  TimeStamp,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PackageListItem(
    arn: Optional[NodePackageArn] = Optional.Absent,
    createdTime: Optional[TimeStamp] = Optional.Absent,
    packageId: Optional[NodePackageId] = Optional.Absent,
    packageName: Optional[NodePackageName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageListItem = {
    import PackageListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageListItem
      .builder()
      .optionallyWith(
        arn.map(value => NodePackageArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        packageId.map(value => NodePackageId.unwrap(value): java.lang.String)
      )(_.packageId)
      .optionallyWith(
        packageName.map(value =>
          NodePackageName.unwrap(value): java.lang.String
        )
      )(_.packageName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageListItem.ReadOnly =
    zio.aws.panorama.model.PackageListItem.wrap(buildAwsValue())
}
object PackageListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageListItem =
      zio.aws.panorama.model.PackageListItem(
        arn.map(value => value),
        createdTime.map(value => value),
        packageId.map(value => value),
        packageName.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[NodePackageArn]
    def createdTime: Optional[TimeStamp]
    def packageId: Optional[NodePackageId]
    def packageName: Optional[NodePackageName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, NodePackageArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getPackageId: ZIO[Any, AwsError, NodePackageId] =
      AwsError.unwrapOptionField("packageId", packageId)
    def getPackageName: ZIO[Any, AwsError, NodePackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageListItem
  ) extends zio.aws.panorama.model.PackageListItem.ReadOnly {
    override val arn: Optional[NodePackageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.panorama.model.primitives.NodePackageArn(value))
    override val createdTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.TimeStamp(value))
    override val packageId: Optional[NodePackageId] = zio.aws.core.internal
      .optionalFromNullable(impl.packageId())
      .map(value => zio.aws.panorama.model.primitives.NodePackageId(value))
    override val packageName: Optional[NodePackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.panorama.model.primitives.NodePackageName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageListItem
  ): zio.aws.panorama.model.PackageListItem.ReadOnly = new Wrapper(impl)
}
