package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackagePatchVersion,
  NodePackageVersion,
  NodePackageName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PackageObject(
    name: NodePackageName,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageObject = {
    import PackageObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageObject
      .builder()
      .name(NodePackageName.unwrap(name): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageObject.ReadOnly =
    zio.aws.panorama.model.PackageObject.wrap(buildAwsValue())
}
object PackageObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageObject =
      zio.aws.panorama.model.PackageObject(name, packageVersion, patchVersion)
    def name: NodePackageName
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def getName: ZIO[Any, Nothing, NodePackageName] = ZIO.succeed(name)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageObject
  ) extends zio.aws.panorama.model.PackageObject.ReadOnly {
    override val name: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.name())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageObject
  ): zio.aws.panorama.model.PackageObject.ReadOnly = new Wrapper(impl)
}
