package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PackageVersionInputConfig(
    s3Location: zio.aws.panorama.model.S3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageVersionInputConfig = {
    import PackageVersionInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageVersionInputConfig
      .builder()
      .s3Location(s3Location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly =
    zio.aws.panorama.model.PackageVersionInputConfig.wrap(buildAwsValue())
}
object PackageVersionInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageVersionInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageVersionInputConfig =
      zio.aws.panorama.model.PackageVersionInputConfig(s3Location.asEditable)
    def s3Location: zio.aws.panorama.model.S3Location.ReadOnly
    def getS3Location
        : ZIO[Any, Nothing, zio.aws.panorama.model.S3Location.ReadOnly] =
      ZIO.succeed(s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageVersionInputConfig
  ) extends zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly {
    override val s3Location: zio.aws.panorama.model.S3Location.ReadOnly =
      zio.aws.panorama.model.S3Location.wrap(impl.s3Location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageVersionInputConfig
  ): zio.aws.panorama.model.PackageVersionInputConfig.ReadOnly = new Wrapper(
    impl
  )
}
