package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackageVersion,
  NodePackageName,
  MarkLatestPatch
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PackageVersionOutputConfig(
    markLatest: Optional[MarkLatestPatch] = Optional.Absent,
    packageName: NodePackageName,
    packageVersion: NodePackageVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.PackageVersionOutputConfig = {
    import PackageVersionOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.PackageVersionOutputConfig
      .builder()
      .optionallyWith(
        markLatest.map(value =>
          MarkLatestPatch.unwrap(value): java.lang.Boolean
        )
      )(_.markLatest)
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly =
    zio.aws.panorama.model.PackageVersionOutputConfig.wrap(buildAwsValue())
}
object PackageVersionOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.PackageVersionOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.PackageVersionOutputConfig =
      zio.aws.panorama.model.PackageVersionOutputConfig(
        markLatest.map(value => value),
        packageName,
        packageVersion
      )
    def markLatest: Optional[MarkLatestPatch]
    def packageName: NodePackageName
    def packageVersion: NodePackageVersion
    def getMarkLatest: ZIO[Any, AwsError, MarkLatestPatch] =
      AwsError.unwrapOptionField("markLatest", markLatest)
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.PackageVersionOutputConfig
  ) extends zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly {
    override val markLatest: Optional[MarkLatestPatch] = zio.aws.core.internal
      .optionalFromNullable(impl.markLatest())
      .map(value => zio.aws.panorama.model.primitives.MarkLatestPatch(value))
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.PackageVersionOutputConfig
  ): zio.aws.panorama.model.PackageVersionOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
