package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait PackageVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.PackageVersionStatus
}
object PackageVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.PackageVersionStatus
  ): zio.aws.panorama.model.PackageVersionStatus = value match {
    case software.amazon.awssdk.services.panorama.model.PackageVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.PackageVersionStatus.REGISTER_PENDING =>
      val r = REGISTER_PENDING
      r
    case software.amazon.awssdk.services.panorama.model.PackageVersionStatus.REGISTER_COMPLETED =>
      val r = REGISTER_COMPLETED
      r
    case software.amazon.awssdk.services.panorama.model.PackageVersionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.panorama.model.PackageVersionStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageVersionStatus =
      software.amazon.awssdk.services.panorama.model.PackageVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTER_PENDING
      extends zio.aws.panorama.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageVersionStatus =
      software.amazon.awssdk.services.panorama.model.PackageVersionStatus.REGISTER_PENDING
  }
  case object REGISTER_COMPLETED
      extends zio.aws.panorama.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageVersionStatus =
      software.amazon.awssdk.services.panorama.model.PackageVersionStatus.REGISTER_COMPLETED
  }
  case object FAILED extends zio.aws.panorama.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageVersionStatus =
      software.amazon.awssdk.services.panorama.model.PackageVersionStatus.FAILED
  }
  case object DELETING extends zio.aws.panorama.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PackageVersionStatus =
      software.amazon.awssdk.services.panorama.model.PackageVersionStatus.DELETING
  }
}
