package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait PortType {
  def unwrap: software.amazon.awssdk.services.panorama.model.PortType
}
object PortType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.PortType
  ): zio.aws.panorama.model.PortType = value match {
    case software.amazon.awssdk.services.panorama.model.PortType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.PortType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.panorama.model.PortType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.panorama.model.PortType.INT32 =>
      val r = INT32
      r
    case software.amazon.awssdk.services.panorama.model.PortType.FLOAT32 =>
      val r = FLOAT32
      r
    case software.amazon.awssdk.services.panorama.model.PortType.MEDIA =>
      val r = MEDIA
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.UNKNOWN_TO_SDK_VERSION
  }
  case object BOOLEAN extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.BOOLEAN
  }
  case object STRING extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.STRING
  }
  case object INT32 extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.INT32
  }
  case object FLOAT32 extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.FLOAT32
  }
  case object MEDIA extends zio.aws.panorama.model.PortType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.PortType =
      software.amazon.awssdk.services.panorama.model.PortType.MEDIA
  }
}
