package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  TagValue,
  TagKey,
  DeviceName,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionDeviceRequest(
    description: Optional[Description] = Optional.Absent,
    name: DeviceName,
    networkingConfiguration: Optional[zio.aws.panorama.model.NetworkPayload] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest = {
    import ProvisionDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(DeviceName.unwrap(name): java.lang.String)
      .optionallyWith(
        networkingConfiguration.map(value => value.buildAwsValue())
      )(_.networkingConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ProvisionDeviceRequest.ReadOnly =
    zio.aws.panorama.model.ProvisionDeviceRequest.wrap(buildAwsValue())
}
object ProvisionDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ProvisionDeviceRequest =
      zio.aws.panorama.model.ProvisionDeviceRequest(
        description.map(value => value),
        name,
        networkingConfiguration.map(value => value.asEditable),
        tags.map(value => value)
      )
    def description: Optional[Description]
    def name: DeviceName
    def networkingConfiguration
        : Optional[zio.aws.panorama.model.NetworkPayload.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(name)
    def getNetworkingConfiguration
        : ZIO[Any, AwsError, zio.aws.panorama.model.NetworkPayload.ReadOnly] =
      AwsError.unwrapOptionField(
        "networkingConfiguration",
        networkingConfiguration
      )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest
  ) extends zio.aws.panorama.model.ProvisionDeviceRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val name: DeviceName =
      zio.aws.panorama.model.primitives.DeviceName(impl.name())
    override val networkingConfiguration
        : Optional[zio.aws.panorama.model.NetworkPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkingConfiguration())
        .map(value => zio.aws.panorama.model.NetworkPayload.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest
  ): zio.aws.panorama.model.ProvisionDeviceRequest.ReadOnly = new Wrapper(impl)
}
