package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  IotThingName,
  DeviceId,
  Certificates,
  DeviceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionDeviceResponse(
    arn: DeviceArn,
    certificates: Optional[Certificates] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    iotThingName: Optional[IotThingName] = Optional.Absent,
    status: zio.aws.panorama.model.DeviceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse = {
    import ProvisionDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse
      .builder()
      .arn(DeviceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        certificates.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.certificates)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        iotThingName.map(value => IotThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly =
    zio.aws.panorama.model.ProvisionDeviceResponse.wrap(buildAwsValue())
}
object ProvisionDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ProvisionDeviceResponse =
      zio.aws.panorama.model.ProvisionDeviceResponse(
        arn,
        certificates.map(value => value),
        deviceId.map(value => value),
        iotThingName.map(value => value),
        status
      )
    def arn: DeviceArn
    def certificates: Optional[Certificates]
    def deviceId: Optional[DeviceId]
    def iotThingName: Optional[IotThingName]
    def status: zio.aws.panorama.model.DeviceStatus
    def getArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(arn)
    def getCertificates: ZIO[Any, AwsError, Certificates] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getIotThingName: ZIO[Any, AwsError, IotThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
    def getStatus: ZIO[Any, Nothing, zio.aws.panorama.model.DeviceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse
  ) extends zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly {
    override val arn: DeviceArn =
      zio.aws.panorama.model.primitives.DeviceArn(impl.arn())
    override val certificates: Optional[Certificates] = zio.aws.core.internal
      .optionalFromNullable(impl.certificates())
      .map(value =>
        zio.aws.panorama.model.primitives
          .Certificates(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val iotThingName: Optional[IotThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.iotThingName())
      .map(value => zio.aws.panorama.model.primitives.IotThingName(value))
    override val status: zio.aws.panorama.model.DeviceStatus =
      zio.aws.panorama.model.DeviceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse
  ): zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly = new Wrapper(impl)
}
