package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackageId,
  MarkLatestPatch,
  NodePackageVersion,
  PackageOwnerAccount,
  NodePackagePatchVersion
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterPackageVersionRequest(
    markLatest: Optional[MarkLatestPatch] = Optional.Absent,
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageId: NodePackageId,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest = {
    import RegisterPackageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest
      .builder()
      .optionallyWith(
        markLatest.map(value =>
          MarkLatestPatch.unwrap(value): java.lang.Boolean
        )
      )(_.markLatest)
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.RegisterPackageVersionRequest.ReadOnly =
    zio.aws.panorama.model.RegisterPackageVersionRequest.wrap(buildAwsValue())
}
object RegisterPackageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.RegisterPackageVersionRequest =
      zio.aws.panorama.model.RegisterPackageVersionRequest(
        markLatest.map(value => value),
        ownerAccount.map(value => value),
        packageId,
        packageVersion,
        patchVersion
      )
    def markLatest: Optional[MarkLatestPatch]
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageId: NodePackageId
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def getMarkLatest: ZIO[Any, AwsError, MarkLatestPatch] =
      AwsError.unwrapOptionField("markLatest", markLatest)
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest
  ) extends zio.aws.panorama.model.RegisterPackageVersionRequest.ReadOnly {
    override val markLatest: Optional[MarkLatestPatch] = zio.aws.core.internal
      .optionalFromNullable(impl.markLatest())
      .map(value => zio.aws.panorama.model.primitives.MarkLatestPatch(value))
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest
  ): zio.aws.panorama.model.RegisterPackageVersionRequest.ReadOnly =
    new Wrapper(impl)
}
