package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveApplicationInstanceRequest(
    applicationInstanceId: ApplicationInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest = {
    import RemoveApplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.RemoveApplicationInstanceRequest.ReadOnly =
    zio.aws.panorama.model.RemoveApplicationInstanceRequest
      .wrap(buildAwsValue())
}
object RemoveApplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.RemoveApplicationInstanceRequest =
      zio.aws.panorama.model
        .RemoveApplicationInstanceRequest(applicationInstanceId)
    def applicationInstanceId: ApplicationInstanceId
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest
  ) extends zio.aws.panorama.model.RemoveApplicationInstanceRequest.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest
  ): zio.aws.panorama.model.RemoveApplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
