package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{RuntimeContextName, TimeStamp}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReportedRuntimeContextState(
    desiredState: zio.aws.panorama.model.DesiredState,
    deviceReportedStatus: zio.aws.panorama.model.DeviceReportedStatus,
    deviceReportedTime: TimeStamp,
    runtimeContextName: RuntimeContextName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState = {
    import ReportedRuntimeContextState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState
      .builder()
      .desiredState(desiredState.unwrap)
      .deviceReportedStatus(deviceReportedStatus.unwrap)
      .deviceReportedTime(TimeStamp.unwrap(deviceReportedTime): Instant)
      .runtimeContextName(
        RuntimeContextName.unwrap(runtimeContextName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly =
    zio.aws.panorama.model.ReportedRuntimeContextState.wrap(buildAwsValue())
}
object ReportedRuntimeContextState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ReportedRuntimeContextState =
      zio.aws.panorama.model.ReportedRuntimeContextState(
        desiredState,
        deviceReportedStatus,
        deviceReportedTime,
        runtimeContextName
      )
    def desiredState: zio.aws.panorama.model.DesiredState
    def deviceReportedStatus: zio.aws.panorama.model.DeviceReportedStatus
    def deviceReportedTime: TimeStamp
    def runtimeContextName: RuntimeContextName
    def getDesiredState
        : ZIO[Any, Nothing, zio.aws.panorama.model.DesiredState] =
      ZIO.succeed(desiredState)
    def getDeviceReportedStatus
        : ZIO[Any, Nothing, zio.aws.panorama.model.DeviceReportedStatus] =
      ZIO.succeed(deviceReportedStatus)
    def getDeviceReportedTime: ZIO[Any, Nothing, TimeStamp] =
      ZIO.succeed(deviceReportedTime)
    def getRuntimeContextName: ZIO[Any, Nothing, RuntimeContextName] =
      ZIO.succeed(runtimeContextName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState
  ) extends zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly {
    override val desiredState: zio.aws.panorama.model.DesiredState =
      zio.aws.panorama.model.DesiredState.wrap(impl.desiredState())
    override val deviceReportedStatus
        : zio.aws.panorama.model.DeviceReportedStatus =
      zio.aws.panorama.model.DeviceReportedStatus
        .wrap(impl.deviceReportedStatus())
    override val deviceReportedTime: TimeStamp =
      zio.aws.panorama.model.primitives.TimeStamp(impl.deviceReportedTime())
    override val runtimeContextName: RuntimeContextName =
      zio.aws.panorama.model.primitives
        .RuntimeContextName(impl.runtimeContextName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState
  ): zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly = new Wrapper(
    impl
  )
}
