package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{Region, ObjectKey, BucketName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucketName: BucketName,
    objectKey: ObjectKey,
    region: Optional[Region] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.S3Location
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .objectKey(ObjectKey.unwrap(objectKey): java.lang.String)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.S3Location.ReadOnly =
    zio.aws.panorama.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.S3Location = zio.aws.panorama.model
      .S3Location(bucketName, objectKey, region.map(value => value))
    def bucketName: BucketName
    def objectKey: ObjectKey
    def region: Optional[Region]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getObjectKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(objectKey)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.S3Location
  ) extends zio.aws.panorama.model.S3Location.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.panorama.model.primitives.BucketName(impl.bucketName())
    override val objectKey: ObjectKey =
      zio.aws.panorama.model.primitives.ObjectKey(impl.objectKey())
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.panorama.model.primitives.Region(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.S3Location
  ): zio.aws.panorama.model.S3Location.ReadOnly = new Wrapper(impl)
}
