package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SignalApplicationInstanceNodeInstancesRequest(
    applicationInstanceId: ApplicationInstanceId,
    nodeSignals: Iterable[zio.aws.panorama.model.NodeSignal]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest = {
    import SignalApplicationInstanceNodeInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .nodeSignals(nodeSignals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest.ReadOnly =
    zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest
      .wrap(buildAwsValue())
}
object SignalApplicationInstanceNodeInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest =
      zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest(
        applicationInstanceId,
        nodeSignals.map { item =>
          item.asEditable
        }
      )
    def applicationInstanceId: ApplicationInstanceId
    def nodeSignals: List[zio.aws.panorama.model.NodeSignal.ReadOnly]
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
    def getNodeSignals
        : ZIO[Any, Nothing, List[zio.aws.panorama.model.NodeSignal.ReadOnly]] =
      ZIO.succeed(nodeSignals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest
  ) extends zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
    override val nodeSignals: List[zio.aws.panorama.model.NodeSignal.ReadOnly] =
      impl
        .nodeSignals()
        .asScala
        .map { item =>
          zio.aws.panorama.model.NodeSignal.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest
  ): zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
