package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SignalApplicationInstanceNodeInstancesResponse(
    applicationInstanceId: ApplicationInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse = {
    import SignalApplicationInstanceNodeInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly =
    zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse
      .wrap(buildAwsValue())
}
object SignalApplicationInstanceNodeInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse =
      zio.aws.panorama.model
        .SignalApplicationInstanceNodeInstancesResponse(applicationInstanceId)
    def applicationInstanceId: ApplicationInstanceId
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse
  ) extends zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse
  ): zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
